// anagram.java
// Program generuje anagramy
// Aby uruchomi program: C>java AnagramApp
import java.io.*;
////////////////////////////////////////////////////////////////
class AnagramApp
   {
   static int size;
   static int count;
   static char[] arrChar = new char[100];
   //-----------------------------------------------------------
   public static void main(String[] args) throws IOException
      {
      System.out.print("Wpisz sowo: ");     // pobieramy sowo
      String input = getString();
      size = input.length();                 // okrelamy jego rozmiar
      count = 0;
      for(int j=0; j<size; j++)              // zapisujemy w tablicy
         arrChar[j] = input.charAt(j);
      doAnagram(size);                       // generujemy anagramy
      }  // koniec metody main()
   //-----------------------------------------------------------
   public static void doAnagram(int newSize)
      {
      int limit;
      if(newSize == 1)                     // jeli sowo zbyt mae,
         return;                           // koczymy wykonywanie metody

      for(int j=0; j<newSize; j++)         // dla kadej pozycji,
         {
         doAnagram(newSize-1);             // anagramy pozostaych liter
         if(newSize==2)                    // jeli najbardziej wewntrzny,
            displayWord();                 // wywietlamy sowo
         rotate(newSize);                  // przesuwamy cyklicznie sowo
         }
      }
   //-----------------------------------------------------------
   // metoda przesuwa o jedn pozycj w lewo wszystkie litery
   // od podanej pozycji a do koca sowa
   public static void rotate(int newSize)
      {
      int j;
      int position = size - newSize;
      char temp = arrChar[position];       // zapamitujemy pierwsz liter
      for(j=position+1; j<size; j++)       // przesuwamy pozostae
         arrChar[j-1] = arrChar[j];
      arrChar[j-1] = temp;                 // zapisujemy pierwsz na kocu
      }
   //-----------------------------------------------------------
   public static void displayWord()
      {
      if(count < 99)
         System.out.print(" ");
      if(count < 9)
         System.out.print(" ");
      System.out.print(++count + " ");
      for(int j=0; j<size; j++)
         System.out.print( arrChar[j] );
      System.out.print("   ");
      System.out.flush();
      if(count%6 == 0)
         System.out.println("");
      }
   //-----------------------------------------------------------
   public static String getString() throws IOException
      {
      InputStreamReader isr = new InputStreamReader(System.in);
      BufferedReader br = new BufferedReader(isr);
      String s = br.readLine();
      return s;
      }
   //-----------------------------------------------------------
   }  // koniec klasy AnagramApp
////////////////////////////////////////////////////////////////
